-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versión del servidor:         8.0.30 - MySQL Community Server - GPL
-- SO del servidor:              Win64
-- HeidiSQL Versión:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Volcando estructura para tabla alquiler.cache
CREATE TABLE IF NOT EXISTS `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.cache: ~1 rows (aproximadamente)
INSERT INTO `cache` (`key`, `value`, `expiration`) VALUES
	('spatie.permission.cache', 'a:3:{s:5:"alias";a:4:{s:1:"a";s:2:"id";s:1:"b";s:4:"name";s:1:"c";s:10:"guard_name";s:1:"r";s:5:"roles";}s:11:"permissions";a:52:{i:0;a:4:{s:1:"a";i:1;s:1:"b";s:9:"ver-panel";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:1;a:4:{s:1:"a";i:2;s:1:"b";s:18:"actualizar-empresa";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:2;a:4:{s:1:"a";i:3;s:1:"b";s:19:"ver-metodos-de-pago";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:3;a:4:{s:1:"a";i:4;s:1:"b";s:21:"crear-metodos-de-pago";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:4;a:4:{s:1:"a";i:5;s:1:"b";s:22:"editar-metodos-de-pago";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:5;a:4:{s:1:"a";i:6;s:1:"b";s:24:"eliminar-metodos-de-pago";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:6;a:4:{s:1:"a";i:7;s:1:"b";s:15:"ver-propiedades";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:7;a:4:{s:1:"a";i:8;s:1:"b";s:17:"crear-propiedades";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:8;a:4:{s:1:"a";i:9;s:1:"b";s:18:"editar-propiedades";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:9;a:4:{s:1:"a";i:10;s:1:"b";s:20:"eliminar-propiedades";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:10;a:4:{s:1:"a";i:11;s:1:"b";s:9:"ver-tipos";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:11;a:4:{s:1:"a";i:12;s:1:"b";s:11:"crear-tipos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:12;a:4:{s:1:"a";i:13;s:1:"b";s:12:"editar-tipos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:13;a:4:{s:1:"a";i:14;s:1:"b";s:14:"eliminar-tipos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:14;a:4:{s:1:"a";i:15;s:1:"b";s:10:"ver-gastos";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:15;a:4:{s:1:"a";i:16;s:1:"b";s:12:"crear-gastos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:16;a:4:{s:1:"a";i:17;s:1:"b";s:13:"editar-gastos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:17;a:4:{s:1:"a";i:18;s:1:"b";s:15:"eliminar-gastos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:18;a:4:{s:1:"a";i:19;s:1:"b";s:15:"reportes-gastos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:19;a:4:{s:1:"a";i:20;s:1:"b";s:9:"ver-cajas";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:20;a:4:{s:1:"a";i:21;s:1:"b";s:11:"abrir-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:21;a:4:{s:1:"a";i:22;s:1:"b";s:12:"cerrar-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:22;a:4:{s:1:"a";i:23;s:1:"b";s:17:"movimientos-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:23;a:4:{s:1:"a";i:24;s:1:"b";s:26:"reportes-movimientos-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:24;a:4:{s:1:"a";i:25;s:1:"b";s:12:"editar-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:25;a:4:{s:1:"a";i:26;s:1:"b";s:14:"eliminar-cajas";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:26;a:4:{s:1:"a";i:27;s:1:"b";s:9:"ver-pagos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:27;a:4:{s:1:"a";i:28;s:1:"b";s:15:"registrar-pagos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:28;a:4:{s:1:"a";i:29;s:1:"b";s:12:"ticket-pagos";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:29;a:4:{s:1:"a";i:30;s:1:"b";s:16:"ver-habitaciones";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:30;a:4:{s:1:"a";i:31;s:1:"b";s:18:"crear-habitaciones";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:31;a:4:{s:1:"a";i:32;s:1:"b";s:19:"editar-habitaciones";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:32;a:4:{s:1:"a";i:33;s:1:"b";s:21:"eliminar-habitaciones";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:33;a:4:{s:1:"a";i:34;s:1:"b";s:12:"ver-clientes";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:34;a:4:{s:1:"a";i:35;s:1:"b";s:14:"crear-clientes";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:35;a:4:{s:1:"a";i:36;s:1:"b";s:15:"editar-clientes";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:36;a:4:{s:1:"a";i:37;s:1:"b";s:17:"eliminar-clientes";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:37;a:4:{s:1:"a";i:38;s:1:"b";s:14:"ver-alquileres";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:38;a:4:{s:1:"a";i:39;s:1:"b";s:16:"crear-alquileres";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:39;a:4:{s:1:"a";i:40;s:1:"b";s:19:"eliminar-alquileres";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:40;a:4:{s:1:"a";i:41;s:1:"b";s:22:"administrar-alquileres";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:41;a:4:{s:1:"a";i:42;s:1:"b";s:27:"ver-historial-de-alquileres";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:42;a:4:{s:1:"a";i:43;s:1:"b";s:12:"ver-usuarios";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:43;a:4:{s:1:"a";i:44;s:1:"b";s:14:"crear-usuarios";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:44;a:4:{s:1:"a";i:45;s:1:"b";s:15:"editar-usuarios";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:45;a:4:{s:1:"a";i:46;s:1:"b";s:17:"eliminar-usuarios";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:46;a:4:{s:1:"a";i:47;s:1:"b";s:9:"ver-roles";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:47;a:4:{s:1:"a";i:48;s:1:"b";s:11:"crear-roles";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:48;a:4:{s:1:"a";i:49;s:1:"b";s:12:"editar-roles";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:49;a:4:{s:1:"a";i:50;s:1:"b";s:14:"eliminar-roles";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:50;a:4:{s:1:"a";i:51;s:1:"b";s:9:"ver-renta";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:51;a:4:{s:1:"a";i:52;s:1:"b";s:22:"realizar-pago-de-renta";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}}s:5:"roles";a:2:{i:0;a:3:{s:1:"a";i:1;s:1:"b";s:13:"administrador";s:1:"c";s:3:"web";}i:1;a:3:{s:1:"a";i:2;s:1:"b";s:7:"usuario";s:1:"c";s:3:"web";}}}', 1768433216);

-- Volcando estructura para tabla alquiler.cache_locks
CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.cache_locks: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.cash_boxes
CREATE TABLE IF NOT EXISTS `cash_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `initial_amount` decimal(10,2) NOT NULL,
  `spent` decimal(10,2) NOT NULL DEFAULT '0.00',
  `closing_date` datetime DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_boxes_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_boxes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.cash_boxes: ~0 rows (aproximadamente)
INSERT INTO `cash_boxes` (`id`, `initial_amount`, `spent`, `closing_date`, `status`, `user_id`, `created_at`, `updated_at`) VALUES
	(1, 0.00, 0.00, NULL, 1, 1, '2025-12-09 19:40:55', '2025-12-09 19:40:55');

-- Volcando estructura para tabla alquiler.clients
CREATE TABLE IF NOT EXISTS `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `full_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_of_birth` date NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identification_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identification_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `clients_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.clients: ~3 rows (aproximadamente)
INSERT INTO `clients` (`id`, `full_name`, `date_of_birth`, `gender`, `phone`, `email`, `address`, `city`, `state`, `postal_code`, `country`, `identification_number`, `identification_type`, `created_at`, `updated_at`) VALUES
	(1, 'Juan Pérez', '1985-06-15', 'Masculino', '987654321', 'juan.perez@example.com', 'Av. Los Olivos 123', 'Lima', 'Lima', '15001', 'Perú', '12345678', 'DNI', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 'María López', '1990-03-20', 'Femenino', '999888777', 'maria.lopez@example.com', 'Calle Las Flores 456', 'Arequipa', 'Arequipa', '04001', 'Perú', '87654321', 'DNI', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 'Carlos Ramírez', '1978-11-05', 'Masculino', '955444333', 'carlos.ramirez@example.com', 'Jr. Comercio 789', 'Cusco', 'Cusco', '08002', 'Perú', '11223344', 'Carnet de Extranjería', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruc` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PEN',
  `currency_symbol` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'S/',
  `exchange_rate` decimal(10,3) NOT NULL DEFAULT '1.000',
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.companies: ~0 rows (aproximadamente)
INSERT INTO `companies` (`id`, `name`, `ruc`, `address`, `phone`, `email`, `currency_code`, `currency_symbol`, `exchange_rate`, `logo`, `created_at`, `updated_at`) VALUES
	(1, 'Mi Empresa S.A.C.', '20123456789', 'Av. Principal 123', '987654321', 'empresa@gmail.com', 'PEN', 'S/', 1.000, NULL, '2025-12-09 19:38:45', '2025-12-09 19:38:45');

-- Volcando estructura para tabla alquiler.expenses
CREATE TABLE IF NOT EXISTS `expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cashbox_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_cashbox_id_foreign` (`cashbox_id`),
  CONSTRAINT `expenses_cashbox_id_foreign` FOREIGN KEY (`cashbox_id`) REFERENCES `cash_boxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.expenses: ~0 rows (aproximadamente)
INSERT INTO `expenses` (`id`, `description`, `amount`, `photo`, `cashbox_id`, `created_at`, `updated_at`) VALUES
	(1, 'Para Navidad', 100.00, NULL, 1, '2025-12-09 19:52:36', '2025-12-09 19:52:36');

-- Volcando estructura para tabla alquiler.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.failed_jobs: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.jobs
CREATE TABLE IF NOT EXISTS `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.jobs: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.job_batches
CREATE TABLE IF NOT EXISTS `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.job_batches: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.migrations: ~0 rows (aproximadamente)
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '0001_01_01_000000_create_users_table', 1),
	(2, '0001_01_01_000001_create_cache_table', 1),
	(3, '0001_01_01_000002_create_jobs_table', 1),
	(4, '2024_07_21_021939_create_properties_table', 1),
	(5, '2024_07_21_154815_create_types_table', 1),
	(6, '2024_07_21_160417_create_rooms_table', 1),
	(7, '2024_07_23_163810_create_clients_table', 1),
	(8, '2024_07_24_162348_create_rents_table', 1),
	(9, '2024_07_24_191640_create_cash_boxes_table', 1),
	(10, '2024_07_24_191921_create_payments_table', 1),
	(11, '2024_07_25_191822_create_expenses_table', 1),
	(12, '2025_12_05_163608_create_companies_table', 1),
	(13, '2025_12_06_024926_create_payment_methods_table', 1),
	(14, '2025_12_06_025626_create_payment_details_table', 1),
	(15, '2025_12_08_210343_create_permission_tables', 1);

-- Volcando estructura para tabla alquiler.model_has_permissions
CREATE TABLE IF NOT EXISTS `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.model_has_permissions: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.model_has_roles
CREATE TABLE IF NOT EXISTS `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.model_has_roles: ~2 rows (aproximadamente)
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
	(1, 'App\\Models\\User', 1),
	(2, 'App\\Models\\User', 3);

-- Volcando estructura para tabla alquiler.password_reset_tokens
CREATE TABLE IF NOT EXISTS `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.password_reset_tokens: ~0 rows (aproximadamente)

-- Volcando estructura para tabla alquiler.payments
CREATE TABLE IF NOT EXISTS `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `amount` decimal(10,2) NOT NULL,
  `used_balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `new_balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `rent_id` bigint unsigned NOT NULL,
  `cashbox_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_rent_id_foreign` (`rent_id`),
  KEY `payments_cashbox_id_foreign` (`cashbox_id`),
  CONSTRAINT `payments_cashbox_id_foreign` FOREIGN KEY (`cashbox_id`) REFERENCES `cash_boxes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `payments_rent_id_foreign` FOREIGN KEY (`rent_id`) REFERENCES `rents` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.payments: ~0 rows (aproximadamente)
INSERT INTO `payments` (`id`, `amount`, `used_balance`, `new_balance`, `rent_id`, `cashbox_id`, `created_at`, `updated_at`) VALUES
	(1, 1000.00, 0.00, 1000.00, 1, 1, '2025-12-09 19:41:12', '2025-12-09 19:41:12'),
	(2, 150.00, 850.00, 150.00, 1, 1, '2025-12-10 15:28:20', '2025-12-10 15:28:20');

-- Volcando estructura para tabla alquiler.payment_details
CREATE TABLE IF NOT EXISTS `payment_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payable_id` bigint unsigned NOT NULL,
  `payment_method_id` bigint unsigned NOT NULL,
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `paid` decimal(10,2) NOT NULL DEFAULT '0.00',
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_details_payable_type_payable_id_index` (`payable_type`,`payable_id`),
  KEY `payment_details_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `payment_details_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.payment_details: ~6 rows (aproximadamente)
INSERT INTO `payment_details` (`id`, `payable_type`, `payable_id`, `payment_method_id`, `total`, `paid`, `reference`, `created_at`, `updated_at`) VALUES
	(1, 'App\\Models\\Payment', 1, 1, 1184.00, 500.00, NULL, '2025-12-09 19:41:12', '2025-12-09 19:41:12'),
	(2, 'App\\Models\\Payment', 1, 2, 1184.00, 500.00, NULL, '2025-12-09 19:41:12', '2025-12-09 19:41:12'),
	(3, 'App\\Models\\Expense', 1, 5, 50.00, 50.00, NULL, '2025-12-09 19:52:36', '2025-12-09 19:52:36'),
	(4, 'App\\Models\\Expense', 1, 6, 50.00, 50.00, NULL, '2025-12-09 19:52:36', '2025-12-09 19:52:36'),
	(5, 'App\\Models\\Payment', 2, 1, 1000.00, 50.00, NULL, '2025-12-10 15:28:20', '2025-12-10 15:28:20'),
	(6, 'App\\Models\\Payment', 2, 2, 1000.00, 100.00, NULL, '2025-12-10 15:28:20', '2025-12-10 15:28:20');

-- Volcando estructura para tabla alquiler.payment_methods
CREATE TABLE IF NOT EXISTS `payment_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.payment_methods: ~6 rows (aproximadamente)
INSERT INTO `payment_methods` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
	(1, 'Efectivo', 'Pago directo en efectivo.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 'Transferencia Bancaria', 'Pago mediante transferencia a la cuenta bancaria de la empresa.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 'Tarjeta de Crédito', 'Pago con tarjeta de crédito VISA, Mastercard, etc.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(4, 'Tarjeta de Débito', 'Pago con tarjeta de débito.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(5, 'Yape', 'Pago mediante Yape.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(6, 'Plin', 'Pago mediante Plin.', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.permissions: ~52 rows (aproximadamente)
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'ver-panel', 'web', '2025-12-09 19:38:45', '2025-12-09 19:38:45'),
	(2, 'actualizar-empresa', 'web', '2025-12-09 19:38:45', '2025-12-09 19:38:45'),
	(3, 'ver-metodos-de-pago', 'web', '2025-12-09 19:38:45', '2025-12-09 19:38:45'),
	(4, 'crear-metodos-de-pago', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(5, 'editar-metodos-de-pago', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(6, 'eliminar-metodos-de-pago', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(7, 'ver-propiedades', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(8, 'crear-propiedades', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(9, 'editar-propiedades', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(10, 'eliminar-propiedades', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(11, 'ver-tipos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(12, 'crear-tipos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(13, 'editar-tipos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(14, 'eliminar-tipos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(15, 'ver-gastos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(16, 'crear-gastos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(17, 'editar-gastos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(18, 'eliminar-gastos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(19, 'reportes-gastos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(20, 'ver-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(21, 'abrir-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(22, 'cerrar-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(23, 'movimientos-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(24, 'reportes-movimientos-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(25, 'editar-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(26, 'eliminar-cajas', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(27, 'ver-pagos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(28, 'registrar-pagos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(29, 'ticket-pagos', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(30, 'ver-habitaciones', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(31, 'crear-habitaciones', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(32, 'editar-habitaciones', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(33, 'eliminar-habitaciones', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(34, 'ver-clientes', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(35, 'crear-clientes', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(36, 'editar-clientes', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(37, 'eliminar-clientes', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(38, 'ver-alquileres', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(39, 'crear-alquileres', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(40, 'eliminar-alquileres', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(41, 'administrar-alquileres', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(42, 'ver-historial-de-alquileres', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(43, 'ver-usuarios', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(44, 'crear-usuarios', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(45, 'editar-usuarios', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(46, 'eliminar-usuarios', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(47, 'ver-roles', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(48, 'crear-roles', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(49, 'editar-roles', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(50, 'eliminar-roles', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(51, 'ver-renta', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(52, 'realizar-pago-de-renta', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.properties
CREATE TABLE IF NOT EXISTS `properties` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `properties_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.properties: ~3 rows (aproximadamente)
INSERT INTO `properties` (`id`, `name`, `city`, `address`, `created_at`, `updated_at`) VALUES
	(1, 'Residencial Los Pinos', 'Lima', 'Av. Universitaria 345, Los Olivos', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 'Edificio Mirador', 'Arequipa', 'Calle La Paz 102, Yanahuara', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 'Torre Central', 'Cusco', 'Jr. Comercio 876, Centro', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.rents
CREATE TABLE IF NOT EXISTS `rents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note` text COLLATE utf8mb4_unicode_ci,
  `client_id` bigint unsigned NOT NULL,
  `room_id` bigint unsigned NOT NULL,
  `start_date` date NOT NULL,
  `modality` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `next_due_date` date NOT NULL,
  `balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rents_client_id_foreign` (`client_id`),
  KEY `rents_room_id_foreign` (`room_id`),
  CONSTRAINT `rents_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rents_room_id_foreign` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.rents: ~0 rows (aproximadamente)
INSERT INTO `rents` (`id`, `note`, `client_id`, `room_id`, `start_date`, `modality`, `price`, `next_due_date`, `balance`, `status`, `created_at`, `updated_at`) VALUES
	(1, 'Por se mi primer cliente en navidad', 2, 12, '2025-12-10', 'monthly', 1000.00, '2026-02-10', 150.00, 1, '2025-12-09 19:40:20', '2025-12-10 15:28:20');

-- Volcando estructura para tabla alquiler.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.roles: ~2 rows (aproximadamente)
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'administrador', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 'usuario', 'web', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.role_has_permissions
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.role_has_permissions: ~64 rows (aproximadamente)
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(1, 1),
	(2, 1),
	(3, 1),
	(4, 1),
	(5, 1),
	(6, 1),
	(7, 1),
	(8, 1),
	(9, 1),
	(10, 1),
	(11, 1),
	(12, 1),
	(13, 1),
	(14, 1),
	(15, 1),
	(16, 1),
	(17, 1),
	(18, 1),
	(19, 1),
	(20, 1),
	(21, 1),
	(22, 1),
	(23, 1),
	(24, 1),
	(25, 1),
	(26, 1),
	(27, 1),
	(28, 1),
	(29, 1),
	(30, 1),
	(31, 1),
	(32, 1),
	(33, 1),
	(34, 1),
	(35, 1),
	(36, 1),
	(37, 1),
	(38, 1),
	(39, 1),
	(40, 1),
	(41, 1),
	(42, 1),
	(43, 1),
	(44, 1),
	(45, 1),
	(46, 1),
	(47, 1),
	(48, 1),
	(49, 1),
	(50, 1),
	(51, 1),
	(52, 1),
	(1, 2),
	(3, 2),
	(7, 2),
	(11, 2),
	(15, 2),
	(20, 2),
	(30, 2),
	(34, 2),
	(38, 2),
	(42, 2),
	(51, 2),
	(52, 2);

-- Volcando estructura para tabla alquiler.rooms
CREATE TABLE IF NOT EXISTS `rooms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rentalprice` decimal(10,2) NOT NULL,
  `lightprice` decimal(10,2) NOT NULL,
  `waterprice` decimal(10,2) NOT NULL,
  `number` int NOT NULL,
  `property_id` bigint unsigned NOT NULL,
  `type_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rooms_property_id_foreign` (`property_id`),
  KEY `rooms_type_id_foreign` (`type_id`),
  CONSTRAINT `rooms_property_id_foreign` FOREIGN KEY (`property_id`) REFERENCES `properties` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rooms_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.rooms: ~12 rows (aproximadamente)
INSERT INTO `rooms` (`id`, `rentalprice`, `lightprice`, `waterprice`, `number`, `property_id`, `type_id`, `created_at`, `updated_at`) VALUES
	(1, 826.00, 21.00, 34.00, 1, 1, 3, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 1353.00, 31.00, 29.00, 2, 1, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 640.00, 28.00, 35.00, 3, 1, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(4, 661.00, 42.00, 19.00, 4, 1, 2, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(5, 898.00, 20.00, 21.00, 1, 2, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(6, 933.00, 25.00, 18.00, 2, 2, 3, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(7, 906.00, 20.00, 15.00, 3, 2, 2, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(8, 768.00, 39.00, 30.00, 4, 2, 2, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(9, 1422.00, 42.00, 15.00, 1, 3, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(10, 1489.00, 39.00, 25.00, 2, 3, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(11, 806.00, 29.00, 22.00, 3, 3, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(12, 1130.00, 25.00, 29.00, 4, 3, 1, '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.sessions
CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.sessions: ~6 rows (aproximadamente)
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
	('4qn0m01TzkGqWGj0SfyfMJ8P19l7ytdsihEWvZ3h', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoiSXczSFBGT2J1U0dwZDZnNTQ1cUtqcUR2MHdQTlRLTDc0Z1VTVVR2OCI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjU6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QiO319', 1765935173),
	('A0EqrTJUvXS9yb7gbo8TeaoWs1UCfCv3LOVtSHE6', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoibXM0RkJGMTFpeXM4ZnlzbGtLMjMyNE51MDFBNmd6Z1IzMHdmYnBpZSI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjU6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QiO319', 1768347711),
	('fhHOeR8HkT59c7ZzGavOZ8tvuzFONFh8Gstug0rA', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoiU2VERTVBZ2JjZUZ6bkJiMVlLaUh2SGxKZXVOWTZyTWh2UURuc05McyI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzE6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QvbG9naW4iO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19', 1765416433),
	('sayACYPjybsTdNWWZbl881iGt2R8fpTxDBjkfPYH', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoiejQ3YWVjZ2pyY0p6eDVrWldybzBFcFhIWjd1UG93ZFpUS2EyaFA3MiI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjU6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QiO319', 1766018915),
	('x36CZj1kEoKSg3u9wXLSI7Ch87z9itvGUinTqU3l', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoiNEYyM1RLV2RGQ0lzdGVGVEdleG1yQnNzZ0M2dWJ6enZXMXlHRXJYSSI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjU6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QiO319', 1765417422),
	('yp3rW0YTuMfbVpnmbGc5rhhAdAqD21Hs6ao8GHOa', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'YTozOntzOjY6Il90b2tlbiI7czo0MDoiVzZXRE9Odjlrd0lMb0hxMW5QcTR5Z3RwZTd5bGFXOHVJOWVyQjNudiI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MjU6Imh0dHA6Ly9hbHF1aWxlci1yb29tLnRlc3QiO319', 1765982975);

-- Volcando estructura para tabla alquiler.types
CREATE TABLE IF NOT EXISTS `types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `types_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.types: ~3 rows (aproximadamente)
INSERT INTO `types` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
	(1, 'Habitación Simple', 'Cuarto individual para una persona.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(2, 'Habitación Doble', 'Espacio para dos personas, incluye closet.', '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 'Mini Departamento', 'Ambiente independiente con baño y cocina.', '2025-12-09 19:38:46', '2025-12-09 19:38:46');

-- Volcando estructura para tabla alquiler.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla alquiler.users: ~1 rows (aproximadamente)
INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`) VALUES
	(1, 'Angel Sifuentes', 'admin@gmail.com', NULL, '$2y$12$jOHlLJ9RHunPbX69nK9gM.qmlMDyKDl9eosXQLbJPwbk4BZq8C.GO', NULL, '2025-12-09 19:38:46', '2025-12-09 19:38:46'),
	(3, 'Ana Perez', 'ana@gmail.com', NULL, '$2y$12$APbaPD6kc1Aerh5StCEe1.6x5dSKBuUr.oJ7T2SsDJ6pt9Lw/4NEm', NULL, '2025-12-11 01:40:21', '2025-12-11 01:40:21');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
